/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.plant;

import com.google.inject.ProvidedBy;
import com.google.inject.Singleton;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import technology.rocketjump.undermount.assets.entities.EntityAssetTypeDictionary;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetType;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetDictionaryProvider;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetsBySpecies;
import technology.rocketjump.undermount.assets.entities.plant.PlantEntityAssetsByType;
import technology.rocketjump.undermount.assets.entities.plant.model.PlantEntityAsset;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.plant.PlantSpeciesDictionary;

@ProvidedBy(value=PlantEntityAssetDictionaryProvider.class)
@Singleton
public class PlantEntityAssetDictionary {
    private final PlantEntityAssetsByType typeMap;
    private final Map<String, PlantEntityAsset> assetsByName = new HashMap<String, PlantEntityAsset>();

    public PlantEntityAssetDictionary(List<PlantEntityAsset> completeAssetList, EntityAssetTypeDictionary entityAssetTypeDictionary, PlantSpeciesDictionary plantSpeciesDictionary) {
        this.typeMap = new PlantEntityAssetsByType(entityAssetTypeDictionary, plantSpeciesDictionary);
        for (PlantEntityAsset asset : completeAssetList) {
            this.typeMap.add(asset);
            this.assetsByName.put(asset.getUniqueName(), asset);
        }
        this.assetsByName.put(PlantEntityAssetsBySpecies.NULL_ENTITY_ASSET.getUniqueName(), PlantEntityAssetsBySpecies.NULL_ENTITY_ASSET);
    }

    public PlantEntityAsset getByUniqueName(String uniqueAssetName) {
        PlantEntityAsset asset = this.assetsByName.get(uniqueAssetName);
        if (asset != null) {
            return asset;
        }
        System.err.println("Could not find asset by name " + uniqueAssetName);
        return PlantEntityAssetsBySpecies.NULL_ENTITY_ASSET;
    }

    public PlantEntityAsset getPlantEntityAsset(EntityAssetType assetType, PlantEntityAttributes attributes) {
        return this.typeMap.get(assetType, attributes);
    }

    public List<PlantEntityAsset> getAllMatchingAssets(EntityAssetType assetType, PlantEntityAttributes attributes) {
        return this.typeMap.getAll(assetType, attributes);
    }
}

